// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Provider.pas' rev: 10.00

#ifndef ProviderHPP
#define ProviderHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Varutils.hpp>	// Pascal unit
#include <Variants.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Dbclient.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <Dsintf.hpp>	// Pascal unit
#include <Activex.hpp>	// Pascal unit
#include <Midas.hpp>	// Pascal unit
#include <Sqltimst.hpp>	// Pascal unit
#include <Widestrings.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------
namespace Provider
{
class DELPHICLASS EDSWriter;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION EDSWriter : public Sysutils::Exception
{
  typedef Sysutils::Exception inherited;

private:
  int FErrorCode;

public:
  __fastcall EDSWriter(AnsiString ErrMsg, long Status);
  __property int ErrorCode = {read=FErrorCode, nodefault};
public:
  /* Exception.CreateFmt */ inline __fastcall EDSWriter(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
  /* Exception.CreateRes */ inline __fastcall EDSWriter(int Ident, Extended Dummy) : Sysutils::Exception(Ident, Dummy) { }
  /* Exception.CreateResFmt */ inline __fastcall EDSWriter(int Ident, const System::TVarRec * Args, const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
  /* Exception.CreateHelp */ inline __fastcall EDSWriter(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
  /* Exception.CreateFmtHelp */ inline __fastcall EDSWriter(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
  /* Exception.CreateResHelp */ inline __fastcall EDSWriter(int Ident, int AHelpContext) : Sysutils::Exception(Ident, AHelpContext) { }
  /* Exception.CreateResFmtHelp */ inline __fastcall EDSWriter(int Ident, const System::TVarRec * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext) { }

public:
  /* TObject.Destroy */ inline __fastcall virtual ~EDSWriter(void) { }

};

#pragma pack(pop)
}

namespace Provider
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TCustomPacketWriter;
class PASCALIMPLEMENTATION TCustomPacketWriter : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Dsintf::_di_IDSWriter FIDSWriter;
	
protected:
	DynamicArray<Byte >  FBuffer;
	virtual void __fastcall AddAttribute(Dsintf::TPcktAttrArea Area, const AnsiString ParamName, const OleVariant &Value, bool IncludeInDelta);
	void __fastcall Check(int Status);
	void __fastcall SetDSWriter(const Dsintf::_di_IDSWriter Value);
	__property Dsintf::_di_IDSWriter DSWriter = {read=FIDSWriter};
	
public:
	__fastcall virtual TCustomPacketWriter(void);
	__fastcall virtual ~TCustomPacketWriter(void);
};


#pragma option push -b-
enum TGetRecordOption { grMetaData, grReset, grXML, grXMLUTF8 };
#pragma option pop

typedef Set<TGetRecordOption, grMetaData, grXMLUTF8>  TGetRecordOptions;

typedef OleVariant __fastcall (__closure *TDataRequestEvent)(System::TObject* Sender, const OleVariant &Input);

#pragma option push -b-
enum TProviderOption { poFetchBlobsOnDemand, poFetchDetailsOnDemand, poIncFieldProps, poCascadeDeletes, poCascadeUpdates, poReadOnly, poAllowMultiRecordUpdates, poDisableInserts, poDisableEdits, poDisableDeletes, poNoReset, poAutoRefresh, poPropogateChanges, poAllowCommandText, poRetainServerOrder, poUseQuoteChar };
#pragma option pop

typedef Set<TProviderOption, poFetchBlobsOnDemand, poUseQuoteChar>  TProviderOptions;

struct TPutFieldInfo;
typedef TPutFieldInfo *PPutFieldInfo;

typedef void __fastcall (__closure *TPutFieldProc)(PPutFieldInfo Info);

struct TPutFieldInfo
{
	
public:
	int FieldNo;
	Db::TField* Field;
	Db::TDataSet* DataSet;
	int Size;
	bool IsDetail;
	bool Opened;
	TPutFieldProc PutProc;
	int LocalFieldIndex;
	void *FieldInfos;
} ;

typedef DynamicArray<TPutFieldInfo >  TInfoArray;

typedef void __fastcall (__closure *TGetParamsEvent)(Db::TDataSet* DataSet, Classes::TList* Params);

typedef void __fastcall (__closure *TOnValidate)(const OleVariant &Delta);

class DELPHICLASS TDataPacketWriter;
class PASCALIMPLEMENTATION TDataPacketWriter : public TCustomPacketWriter 
{
	typedef TCustomPacketWriter inherited;
	
private:
	bool FConstraints;
	DynamicArray<TPutFieldInfo >  FPutFieldInfo;
	TProviderOptions FOptions;
	TGetRecordOptions FPacketOptions;
	TGetParamsEvent FOnGetParams;
	
protected:
	virtual void __fastcall AddColumn(const TPutFieldInfo &Info);
	virtual void __fastcall AddConstraints(Db::TDataSet* DataSet);
	virtual void __fastcall AddDataSetAttributes(Db::TDataSet* DataSet);
	void __fastcall AddExtraFieldProps(Db::TField* Field);
	virtual void __fastcall AddFieldLinks(const TInfoArray Info);
	virtual void __fastcall AddIndexDefs(Db::TDataSet* DataSet, const TInfoArray Info);
	void __fastcall FreeInfoRecords(TInfoArray &Info);
	int __fastcall GetFieldIdx(const WideString FieldName, const TInfoArray Info);
	TInfoArray __fastcall InitPutProcs(Db::TDataSet* ADataSet, int &GlobalIdx);
	void __fastcall RefreshPutProcs(Db::TDataSet* ADataSet, TInfoArray &Info);
	void __fastcall PutADTField(PPutFieldInfo Info);
	void __fastcall PutArrayField(PPutFieldInfo Info);
	void __fastcall PutBlobField(PPutFieldInfo Info);
	void __fastcall PutCalcField(PPutFieldInfo Info);
	void __fastcall PutDataSetField(PPutFieldInfo Info);
	void __fastcall PutField(PPutFieldInfo Info);
	void __fastcall PutStringField(PPutFieldInfo Info);
	void __fastcall PutWideStringField(PPutFieldInfo Info);
	void __fastcall PutVarBytesField(PPutFieldInfo Info);
	virtual void __fastcall WriteMetaData(Db::TDataSet* DataSet, const TInfoArray Info, bool IsReference = false);
	virtual int __fastcall WriteDataSet(Db::TDataSet* DataSet, TInfoArray &Info, int RecsOut);
	
public:
	__fastcall virtual ~TDataPacketWriter(void);
	virtual void __fastcall GetDataPacket(Db::TDataSet* DataSet, int &RecsOut, /* out */ OleVariant &Data);
	void __fastcall Reset(void);
	__property bool Constraints = {read=FConstraints, write=FConstraints, nodefault};
	__property TGetRecordOptions PacketOptions = {read=FPacketOptions, write=FPacketOptions, nodefault};
	__property TProviderOptions Options = {read=FOptions, write=FOptions, nodefault};
	__property TGetParamsEvent OnGetParams = {read=FOnGetParams, write=FOnGetParams};
public:
	#pragma option push -w-inl
	/* TCustomPacketWriter.Create */ inline __fastcall virtual TDataPacketWriter(void) : TCustomPacketWriter() { }
	#pragma option pop
	
};


class DELPHICLASS TPacketDataSet;
class PASCALIMPLEMENTATION TPacketDataSet : public Dbclient::TCustomClientDataSet 
{
	typedef Dbclient::TCustomClientDataSet inherited;
	
private:
	char *FOldRecBuf;
	char *FCurRecBuf;
	char *FCurValues;
	bool FUseCurValues;
	bool FWritingCurValues;
	bool FNewValuesModified;
	bool __fastcall GetStreamMetaData(void);
	void __fastcall SetStreamMetaData(bool Value);
	void __fastcall SetWritingCurValues(const bool Value);
	
protected:
	virtual void __fastcall DataEvent(Db::TDataEvent Event, int Info);
	virtual Variant __fastcall GetStateFieldValue(Db::TDataSetState State, Db::TField* Field);
	virtual void __fastcall InternalClose(void);
	virtual void __fastcall InternalOpen(void);
	virtual void __fastcall InternalInitRecord(char * Buffer);
	virtual void __fastcall SetFieldData(Db::TField* Field, void * Buffer)/* overload */;
	virtual void __fastcall SetStateFieldValue(Db::TDataSetState State, Db::TField* Field, const Variant &Value);
	__property bool WritingCurValues = {read=FWritingCurValues, write=SetWritingCurValues, nodefault};
	
public:
	__fastcall virtual TPacketDataSet(Classes::TComponent* AOwner);
	void __fastcall AssignCurValues(Db::TDataSet* Source)/* overload */;
	void __fastcall AssignCurValues(const Variant &CurValues)/* overload */;
	void __fastcall CreateFromDelta(TPacketDataSet* Source);
	bool __fastcall HasCurValues(void);
	bool __fastcall HasMergeConflicts(void);
	void __fastcall InitAltRecBuffers(bool CheckModified = true);
	Db::TUpdateKind __fastcall UpdateKind(void);
	__property bool NewValuesModified = {read=FNewValuesModified, nodefault};
	__property bool StreamMetaData = {read=GetStreamMetaData, write=SetStreamMetaData, nodefault};
	__property bool UseCurValues = {read=FUseCurValues, write=FUseCurValues, nodefault};
public:
	#pragma option push -w-inl
	/* TCustomClientDataSet.Destroy */ inline __fastcall virtual ~TPacketDataSet(void) { }
	#pragma option pop
	
	
/* Hoisted overloads: */
	
protected:
	inline void __fastcall  SetFieldData(Db::TField* Field, void * Buffer, bool NativeFormat){ TDataSet::SetFieldData(Field, Buffer, NativeFormat); }
	
};


class DELPHICLASS TCustomProvider;
class PASCALIMPLEMENTATION TCustomProvider : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	bool FExported;
	OleVariant FOwnerData;
	Sysutils::Exception* FActiveUpdateAbortException;
	TDataRequestEvent FOnDataRequest;
	TOnValidate FOnValidate;
	Dbclient::TRemoteEvent FBeforeApplyUpdates;
	Dbclient::TRemoteEvent FAfterApplyUpdates;
	Dbclient::TRemoteEvent FBeforeGetRecords;
	Dbclient::TRemoteEvent FAfterGetRecords;
	Dbclient::TRemoteEvent FBeforeRowRequest;
	Dbclient::TRemoteEvent FAfterRowRequest;
	Dbclient::TRemoteEvent FBeforeExecute;
	Dbclient::TRemoteEvent FAfterExecute;
	Dbclient::TRemoteEvent FBeforeGetParams;
	Dbclient::TRemoteEvent FAfterGetParams;
	OleVariant __fastcall GetData();
	
protected:
	virtual OleVariant __fastcall DoApplyUpdates(const OleVariant &Delta, int MaxErrors, /* out */ int &ErrorCount, OleVariant &OwnerData);
	virtual OleVariant __fastcall DoGetRecords(int Count, /* out */ int &RecsOut, int Options, const WideString CommandText, OleVariant &Params, OleVariant &OwnerData);
	virtual OleVariant __fastcall InternalApplyUpdates(const OleVariant &Delta, int MaxErrors, /* out */ int &ErrorCount) = 0 ;
	virtual OleVariant __fastcall InternalGetRecords(int Count, /* out */ int &RecsOut, TGetRecordOptions Options, const WideString CommandText, OleVariant &Params);
	virtual OleVariant __fastcall InternalRowRequest(const OleVariant &Row, Dbclient::TFetchOptions RequestType);
	virtual void __fastcall InternalExecute(const WideString CommandText, OleVariant &Params);
	virtual OleVariant __fastcall InternalGetParams(Db::TParamTypes Types = (Set<Db::TParamType, ptUnknown, ptResult> () << Db::TParamType(0) << Db::TParamType(1) << Db::TParamType(2) << Db::TParamType(3) << Db::TParamType(4) ));
	virtual void __fastcall DoAfterApplyUpdates(OleVariant &OwnerData);
	virtual void __fastcall DoBeforeApplyUpdates(OleVariant &OwnerData);
	virtual void __fastcall DoAfterExecute(OleVariant &OwnerData);
	virtual void __fastcall DoBeforeExecute(const WideString CommandText, OleVariant &Params, OleVariant &OwnerData);
	virtual void __fastcall DoAfterGetParams(OleVariant &OwnerData);
	virtual void __fastcall DoBeforeGetParams(OleVariant &OwnerData);
	virtual void __fastcall DoAfterGetRecords(OleVariant &OwnerData);
	virtual void __fastcall DoBeforeGetRecords(int Count, int Options, const WideString CommandText, OleVariant &Params, OleVariant &OwnerData);
	virtual void __fastcall DoAfterRowRequest(OleVariant &OwnerData);
	virtual void __fastcall DoBeforeRowRequest(OleVariant &OwnerData);
	__property TDataRequestEvent OnDataRequest = {read=FOnDataRequest, write=FOnDataRequest};
	__property TOnValidate OnValidate = {read=FOnValidate, write=FOnValidate};
	__property Dbclient::TRemoteEvent BeforeApplyUpdates = {read=FBeforeApplyUpdates, write=FBeforeApplyUpdates};
	__property Dbclient::TRemoteEvent AfterApplyUpdates = {read=FAfterApplyUpdates, write=FAfterApplyUpdates};
	__property Dbclient::TRemoteEvent BeforeGetRecords = {read=FBeforeGetRecords, write=FBeforeGetRecords};
	__property Dbclient::TRemoteEvent AfterGetRecords = {read=FAfterGetRecords, write=FAfterGetRecords};
	__property Dbclient::TRemoteEvent BeforeRowRequest = {read=FBeforeRowRequest, write=FBeforeRowRequest};
	__property Dbclient::TRemoteEvent AfterRowRequest = {read=FAfterRowRequest, write=FAfterRowRequest};
	__property Dbclient::TRemoteEvent BeforeExecute = {read=FBeforeExecute, write=FBeforeExecute};
	__property Dbclient::TRemoteEvent AfterExecute = {read=FAfterExecute, write=FAfterExecute};
	__property Dbclient::TRemoteEvent BeforeGetParams = {read=FBeforeGetParams, write=FBeforeGetParams};
	__property Dbclient::TRemoteEvent AfterGetParams = {read=FAfterGetParams, write=FAfterGetParams};
	void __fastcall SetActiveUpdateException(Sysutils::Exception* E);
	__property Sysutils::Exception* ActiveUpdateException = {read=FActiveUpdateAbortException};
	__property OleVariant OwnerData = {read=FOwnerData, write=FOwnerData};
	
public:
	__fastcall virtual TCustomProvider(Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomProvider(void);
	OleVariant __fastcall ApplyUpdates(const OleVariant &Delta, int MaxErrors, /* out */ int &ErrorCount)/* overload */;
	OleVariant __fastcall ApplyUpdates(const OleVariant &Delta, int MaxErrors, /* out */ int &ErrorCount, OleVariant &OwnerData)/* overload */;
	OleVariant __fastcall GetRecords(int Count, /* out */ int &RecsOut, int Options)/* overload */;
	OleVariant __fastcall GetRecords(int Count, /* out */ int &RecsOut, int Options, const WideString CommandText, OleVariant &Params, OleVariant &OwnerData)/* overload */;
	virtual OleVariant __fastcall RowRequest(const OleVariant &Row, int RequestType, OleVariant &OwnerData);
	virtual void __fastcall Execute(const WideString CommandText, OleVariant &Params, OleVariant &OwnerData);
	virtual OleVariant __fastcall GetParams(OleVariant &OwnerData);
	virtual OleVariant __fastcall DataRequest(const OleVariant &Input);
	__property OleVariant Data = {read=GetData};
	__property bool Exported = {read=FExported, write=FExported, default=1};
};


#pragma option push -b-
enum TResolverResponse { rrSkip, rrAbort, rrMerge, rrApply, rrIgnore };
#pragma option pop

typedef void __fastcall (__closure *TProviderDataEvent)(System::TObject* Sender, Dbclient::TCustomClientDataSet* DataSet);

typedef void __fastcall (__closure *TBeforeUpdateRecordEvent)(System::TObject* Sender, Db::TDataSet* SourceDS, Dbclient::TCustomClientDataSet* DeltaDS, Db::TUpdateKind UpdateKind, bool &Applied);

typedef void __fastcall (__closure *TAfterUpdateRecordEvent)(System::TObject* Sender, Db::TDataSet* SourceDS, Dbclient::TCustomClientDataSet* DeltaDS, Db::TUpdateKind UpdateKind);

typedef void __fastcall (__closure *TResolverErrorEvent)(System::TObject* Sender, Dbclient::TCustomClientDataSet* DataSet, Db::EUpdateError* E, Db::TUpdateKind UpdateKind, TResolverResponse &Response);

typedef void __fastcall (__closure *TBeforeCommitEvent)(System::TObject* Sender, Dbclient::TCustomClientDataSet* DeltaDS, int ErrorCount, int MaxErrors, const OleVariant &ResultVar);

class DELPHICLASS TBaseProvider;
class DELPHICLASS TCustomResolver;
class DELPHICLASS TUpdateTree;
class PASCALIMPLEMENTATION TUpdateTree : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TPacketDataSet* FDeltaDS;
	TPacketDataSet* FErrorDS;
	bool FOpened;
	Db::TDataSet* FSourceDS;
	TUpdateTree* FParent;
	Classes::TList* FDetails;
	void *FData;
	TCustomResolver* FResolver;
	WideString FName;
	int __fastcall GetDetailCount(void);
	TUpdateTree* __fastcall GetDetail(int Index);
	TPacketDataSet* __fastcall GetErrorDS(void);
	bool __fastcall GetHasErrors(void);
	bool __fastcall GetIsNested(void);
	TUpdateTree* __fastcall GetTree(const WideString AName);
	
protected:
	__property bool Opened = {read=FOpened, write=FOpened, nodefault};
	__property Classes::TList* DetailList = {read=FDetails};
	
public:
	__fastcall TUpdateTree(TUpdateTree* AParent, TCustomResolver* AResolver);
	__fastcall virtual ~TUpdateTree(void);
	virtual void __fastcall Clear(void);
	virtual bool __fastcall DoUpdates(void);
	virtual void __fastcall InitData(Db::TDataSet* ASource);
	virtual void __fastcall InitDelta(TPacketDataSet* ADelta)/* overload */;
	virtual void __fastcall InitDelta(const OleVariant &ADelta)/* overload */;
	virtual void __fastcall InitErrorPacket(Db::EUpdateError* E, TResolverResponse Response);
	virtual void __fastcall RefreshData(Dbclient::TFetchOptions Options);
	__property void * Data = {read=FData, write=FData};
	__property TPacketDataSet* Delta = {read=FDeltaDS, write=FDeltaDS};
	__property int DetailCount = {read=GetDetailCount, nodefault};
	__property TUpdateTree* Details[int Index] = {read=GetDetail};
	__property TPacketDataSet* ErrorDS = {read=GetErrorDS, write=FErrorDS};
	__property bool HasErrors = {read=GetHasErrors, nodefault};
	__property bool IsNested = {read=GetIsNested, nodefault};
	__property WideString Name = {read=FName, write=FName};
	__property TUpdateTree* Parent = {read=FParent};
	__property TCustomResolver* Resolver = {read=FResolver};
	__property Db::TDataSet* Source = {read=FSourceDS, write=FSourceDS};
};


class PASCALIMPLEMENTATION TCustomResolver : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TBaseProvider* FProvider;
	TResolverResponse FPrevResponse;
	int FErrorCount;
	int FMaxErrors;
	TUpdateTree* FUpdateTree;
	
protected:
	virtual bool __fastcall HandleUpdateError(TUpdateTree* Tree, Db::EUpdateError* E, int &MaxErrors, int &ErrorCount);
	virtual void __fastcall LogUpdateRecord(TUpdateTree* Tree);
	virtual void __fastcall LogUpdateError(TUpdateTree* Tree, Db::EUpdateError* E, TResolverResponse Response);
	virtual void __fastcall BeginUpdate(void);
	virtual void __fastcall EndUpdate(void);
	virtual void __fastcall DoUpdate(TUpdateTree* Tree) = 0 ;
	virtual void __fastcall DoDelete(TUpdateTree* Tree) = 0 ;
	virtual void __fastcall DoInsert(TUpdateTree* Tree) = 0 ;
	virtual void __fastcall InitializeConflictBuffer(TUpdateTree* Tree) = 0 ;
	
public:
	__fastcall TCustomResolver(TBaseProvider* AProvider);
	__fastcall virtual ~TCustomResolver(void);
	virtual OleVariant __fastcall ApplyUpdates(const OleVariant &Delta, int MaxErrors, /* out */ int &ErrorCount);
	virtual void __fastcall FreeTreeData(TUpdateTree* Tree);
	virtual void __fastcall InitKeyFields(TUpdateTree* Tree, TPacketDataSet* ADelta);
	virtual void __fastcall InitTreeData(TUpdateTree* Tree);
	virtual void __fastcall InternalBeforeResolve(TUpdateTree* Tree);
	virtual bool __fastcall InternalUpdateRecord(TUpdateTree* Tree);
	virtual OleVariant __fastcall RowRequest(const OleVariant &Row, Dbclient::TFetchOptions Options);
	__property TBaseProvider* Provider = {read=FProvider};
	__property TUpdateTree* UpdateTree = {read=FUpdateTree};
};


class PASCALIMPLEMENTATION TBaseProvider : public TCustomProvider 
{
	typedef TCustomProvider inherited;
	
private:
	TPacketDataSet* FDataDS;
	Db::TUpdateMode FUpdateMode;
	TCustomResolver* FResolver;
	TProviderDataEvent FOnGetData;
	TProviderDataEvent FOnUpdateData;
	TResolverErrorEvent FOnUpdateError;
	TBeforeUpdateRecordEvent FBeforeUpdateRecord;
	TAfterUpdateRecordEvent FAfterUpdateRecord;
	TBeforeCommitEvent FBeforeCommit;
	TProviderOptions FProviderOptions;
	
protected:
	void __fastcall CheckResolver(void);
	virtual TCustomResolver* __fastcall CreateResolver(void);
	void __fastcall FreeResolver(void);
	virtual void __fastcall CreateDataPacket(TGetRecordOptions PacketOpts, TProviderOptions ProvOpts, int &RecsOut, OleVariant &Data);
	virtual void __fastcall DoBeforeCommit(TPacketDataSet* Delta, int ErrorCount, int MaxErrors, const OleVariant &ReturnVar);
	virtual void __fastcall DoOnGetData(OleVariant &Data);
	void __fastcall DoOnUpdateData(TPacketDataSet* Delta);
	virtual void __fastcall DoBeforeUpdateRecord(Db::TDataSet* SourceDS, Dbclient::TCustomClientDataSet* DeltaDS, Db::TUpdateKind UpdateKind, bool &Applied);
	virtual void __fastcall DoAfterUpdateRecord(Db::TDataSet* SourceDS, Dbclient::TCustomClientDataSet* DeltaDS, Db::TUpdateKind UpdateKind);
	virtual void __fastcall LocateRecord(Db::TDataSet* Source, Db::TDataSet* Delta);
	virtual void __fastcall UpdateRecord(Db::TDataSet* Source, Db::TDataSet* Delta, bool BlobsOnly, bool KeyOnly);
	virtual void __fastcall FetchDetails(Db::TDataSet* Source, Db::TDataSet* Delta);
	virtual OleVariant __fastcall InternalRowRequest(const OleVariant &Row, Dbclient::TFetchOptions RequestType);
	virtual OleVariant __fastcall InternalApplyUpdates(const OleVariant &Delta, int MaxErrors, /* out */ int &ErrorCount);
	virtual OleVariant __fastcall InternalGetRecords(int Count, /* out */ int &RecsOut, TGetRecordOptions Options, const WideString CommandText, OleVariant &Params);
	__property TPacketDataSet* PacketDataSet = {read=FDataDS, write=FDataDS};
	
public:
	__fastcall virtual TBaseProvider(Classes::TComponent* AOwner);
	__fastcall virtual ~TBaseProvider(void);
	__property TCustomResolver* Resolver = {read=FResolver};
	__property TProviderOptions Options = {read=FProviderOptions, write=FProviderOptions, default=32768};
	__property Db::TUpdateMode UpdateMode = {read=FUpdateMode, write=FUpdateMode, default=0};
	__property OnDataRequest ;
	__property TProviderDataEvent OnGetData = {read=FOnGetData, write=FOnGetData};
	__property TProviderDataEvent OnUpdateData = {read=FOnUpdateData, write=FOnUpdateData};
	__property TResolverErrorEvent OnUpdateError = {read=FOnUpdateError, write=FOnUpdateError};
	__property TBeforeUpdateRecordEvent BeforeUpdateRecord = {read=FBeforeUpdateRecord, write=FBeforeUpdateRecord};
	__property TAfterUpdateRecordEvent AfterUpdateRecord = {read=FAfterUpdateRecord, write=FAfterUpdateRecord};
};


typedef void __fastcall (__closure *TGetTableNameEvent)(System::TObject* Sender, Db::TDataSet* DataSet, WideString &TableName);

typedef void __fastcall (__closure *TGetDSProps)(System::TObject* Sender, Db::TDataSet* DataSet, /* out */ OleVariant &Properties);

class DELPHICLASS TDataSetProvider;
class PASCALIMPLEMENTATION TDataSetProvider : public TBaseProvider 
{
	typedef TBaseProvider inherited;
	
private:
	Db::TDataSet* FDataSet;
	bool FDataSetOpened;
	TDataPacketWriter* FDSWriter;
	TGetDSProps FGetDSProps;
	Db::TParams* FParams;
	bool FResolveToDataSet;
	int FRecordsSent;
	bool FConstraints;
	bool FTransactionStarted;
	TGetTableNameEvent FGetTableName;
	void __fastcall SetDataSet(Db::TDataSet* ADataSet);
	void __fastcall SetResolveToDataSet(bool Value);
	
protected:
	virtual void __fastcall DoGetTableName(Db::TDataSet* DataSet, WideString &TableName);
	virtual void __fastcall DoBeforeGetRecords(int Count, int Options, const WideString CommandText, OleVariant &Params, OleVariant &OwnerData);
	virtual void __fastcall DoBeforeExecute(const WideString CommandText, OleVariant &Params, OleVariant &OwnerData);
	void __fastcall CheckDataSet(void);
	virtual void __fastcall DoGetProviderAttributes(Db::TDataSet* DataSet, Classes::TList* List);
	virtual TCustomResolver* __fastcall CreateResolver(void);
	virtual void __fastcall CreateDataPacket(TGetRecordOptions PacketOpts, TProviderOptions ProvOpts, int &RecsOut, OleVariant &Data);
	virtual Db::TDataSet* __fastcall GetDataSetFromDelta(TUpdateTree* ATree, Db::TDataSet* Source, Db::TDataSet* Delta, Db::TUpdateMode Mode);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall LocateRecord(Db::TDataSet* Source, Db::TDataSet* Delta);
	virtual void __fastcall UpdateRecord(Db::TDataSet* Source, Db::TDataSet* Delta, bool BlobsOnly, bool KeyOnly);
	virtual void __fastcall FetchDetails(Db::TDataSet* Source, Db::TDataSet* Delta);
	virtual OleVariant __fastcall InternalRowRequest(const OleVariant &Row, Dbclient::TFetchOptions Options);
	virtual OleVariant __fastcall InternalGetParams(Db::TParamTypes Types = (Set<Db::TParamType, ptUnknown, ptResult> () << Db::TParamType(0) << Db::TParamType(1) << Db::TParamType(2) << Db::TParamType(3) << Db::TParamType(4) ));
	virtual void __fastcall InternalExecute(const WideString CommandText, OleVariant &Params);
	virtual OleVariant __fastcall InternalGetRecords(int Count, /* out */ int &RecsOut, TGetRecordOptions Options, const WideString CommandText, OleVariant &Params);
	virtual OleVariant __fastcall InternalApplyUpdates(const OleVariant &Delta, int MaxErrors, /* out */ int &ErrorCount);
	virtual bool __fastcall FindRecord(Db::TDataSet* Source, Db::TDataSet* Delta, Db::TUpdateMode UpdateMode);
	void __fastcall Reset(void);
	virtual void __fastcall SetCommandText(const WideString CommandText);
	virtual void __fastcall SetParams(const OleVariant &Values);
	__property bool TransactionStarted = {read=FTransactionStarted, write=FTransactionStarted, nodefault};
	
public:
	__fastcall virtual TDataSetProvider(Classes::TComponent* AOwner);
	__fastcall virtual ~TDataSetProvider(void);
	__property ActiveUpdateException ;
	__property OwnerData ;
	__property Db::TParams* Params = {read=FParams};
	
__published:
	__property Db::TDataSet* DataSet = {read=FDataSet, write=SetDataSet};
	__property bool Constraints = {read=FConstraints, write=FConstraints, default=1};
	__property bool ResolveToDataSet = {read=FResolveToDataSet, write=SetResolveToDataSet, default=0};
	__property Exported  = {default=1};
	__property Options  = {default=32768};
	__property UpdateMode  = {default=0};
	__property OnDataRequest ;
	__property OnGetData ;
	__property OnUpdateData ;
	__property OnUpdateError ;
	__property AfterUpdateRecord ;
	__property BeforeUpdateRecord ;
	__property OnValidate ;
	__property BeforeApplyUpdates ;
	__property AfterApplyUpdates ;
	__property BeforeGetRecords ;
	__property AfterGetRecords ;
	__property BeforeRowRequest ;
	__property AfterRowRequest ;
	__property BeforeExecute ;
	__property AfterExecute ;
	__property BeforeGetParams ;
	__property AfterGetParams ;
	__property TGetTableNameEvent OnGetTableName = {read=FGetTableName, write=FGetTableName};
	__property TGetDSProps OnGetDataSetProperties = {read=FGetDSProps, write=FGetDSProps};
};


class DELPHICLASS TProvider;
class PASCALIMPLEMENTATION TProvider : public TDataSetProvider 
{
	typedef TDataSetProvider inherited;
	
public:
	#pragma option push -w-inl
	/* TDataSetProvider.Create */ inline __fastcall virtual TProvider(Classes::TComponent* AOwner) : TDataSetProvider(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TDataSetProvider.Destroy */ inline __fastcall virtual ~TProvider(void) { }
	#pragma option pop
	
};


class DELPHICLASS TDataSetResolver;
class PASCALIMPLEMENTATION TDataSetResolver : public TCustomResolver 
{
	typedef TCustomResolver inherited;
	
private:
	AnsiString FBookmark;
	bool FOpened;
	TDataSetProvider* __fastcall GetProvider(void);
	void __fastcall PutRecord(TUpdateTree* Tree);
	
protected:
	__property TDataSetProvider* Provider = {read=GetProvider};
	virtual void __fastcall BeginUpdate(void);
	virtual void __fastcall DoUpdate(TUpdateTree* Tree);
	virtual void __fastcall DoDelete(TUpdateTree* Tree);
	virtual void __fastcall DoInsert(TUpdateTree* Tree);
	virtual void __fastcall EndUpdate(void);
	virtual void __fastcall InitializeConflictBuffer(TUpdateTree* Tree);
	
public:
	__fastcall TDataSetResolver(TDataSetProvider* AProvider);
	virtual void __fastcall InternalBeforeResolve(TUpdateTree* Tree);
public:
	#pragma option push -w-inl
	/* TCustomResolver.Destroy */ inline __fastcall virtual ~TDataSetResolver(void) { }
	#pragma option pop
	
};


class DELPHICLASS TSQLResolver;
class PASCALIMPLEMENTATION TSQLResolver : public TCustomResolver 
{
	typedef TCustomResolver inherited;
	
private:
	Widestrings::TWideStringList* FSQL;
	Db::TParams* FParams;
	
protected:
	virtual TDataSetProvider* __fastcall GetProvider(void);
	virtual void __fastcall GenWhereSQL(TUpdateTree* Tree, Widestrings::TWideStrings* SQL, Db::TParams* Params, Db::TUpdateMode GenUpdateMode, AnsiString Alias);
	virtual void __fastcall GenInsertSQL(TUpdateTree* Tree, Widestrings::TWideStrings* SQL, Db::TParams* Params);
	virtual void __fastcall GenDeleteSQL(TUpdateTree* Tree, Widestrings::TWideStrings* SQL, Db::TParams* Params, AnsiString Alias);
	virtual void __fastcall GenUpdateSQL(TUpdateTree* Tree, Widestrings::TWideStrings* SQL, Db::TParams* Params, AnsiString Alias);
	virtual void __fastcall GenSelectSQL(TUpdateTree* Tree, Widestrings::TWideStrings* SQL, Db::TParams* Params, AnsiString Alias, Db::TUpdateMode Mode = (Db::TUpdateMode)(0x2));
	virtual bool __fastcall UseFieldInUpdate(Db::TField* Field);
	virtual bool __fastcall UseFieldInWhere(Db::TField* Field, Db::TUpdateMode Mode);
	virtual void __fastcall InternalDoUpdate(TUpdateTree* Tree, Db::TUpdateKind UpdateKind);
	virtual void __fastcall DoExecSQL(Widestrings::TWideStringList* SQL, Db::TParams* Params);
	virtual void __fastcall DoGetValues(Widestrings::TWideStringList* SQL, Db::TParams* Params, Db::TDataSet* DataSet);
	virtual void __fastcall DoUpdate(TUpdateTree* Tree);
	virtual void __fastcall DoDelete(TUpdateTree* Tree);
	virtual void __fastcall DoInsert(TUpdateTree* Tree);
	virtual void __fastcall InitializeConflictBuffer(TUpdateTree* Tree);
	__property TDataSetProvider* Provider = {read=GetProvider};
	
public:
	__fastcall TSQLResolver(TDataSetProvider* AProvider);
	__fastcall virtual ~TSQLResolver(void);
	virtual void __fastcall FreeTreeData(TUpdateTree* Tree);
	virtual void __fastcall InitTreeData(TUpdateTree* Tree);
};


class DELPHICLASS TLocalAppServer;
class PASCALIMPLEMENTATION TLocalAppServer : public System::TInterfacedObject 
{
	typedef System::TInterfacedObject inherited;
	
private:
	TCustomProvider* FProvider;
	bool FProviderCreated;
	
protected:
	HRESULT __stdcall GetTypeInfoCount(/* out */ int &Count);
	HRESULT __stdcall GetTypeInfo(int Index, int LocaleID, /* out */ void *TypeInfo);
	HRESULT __stdcall GetIDsOfNames(const GUID &IID, void * Names, int NameCount, int LocaleID, void * DispIDs);
	HRESULT __stdcall Invoke(int DispID, const GUID &IID, int LocaleID, Word Flags, void *Params, void * VarResult, void * ExcepInfo, void * ArgErr);
	HRESULT __safecall AS_ApplyUpdates(const WideString ProviderName, const OleVariant Delta, int MaxErrors, /* out */ int &ErrorCount, OleVariant &OwnerData, OleVariant &AS_ApplyUpdates_result);
	HRESULT __safecall AS_GetRecords(const WideString ProviderName, int Count, /* out */ int &RecsOut, int Options, const WideString CommandText, OleVariant &Params, OleVariant &OwnerData, OleVariant &AS_GetRecords_result);
	HRESULT __safecall AS_DataRequest(const WideString ProviderName, const OleVariant Data, OleVariant &AS_DataRequest_result);
	HRESULT __safecall AS_GetProviderNames(OleVariant &AS_GetProviderNames_result);
	HRESULT __safecall AS_GetParams(const WideString ProviderName, OleVariant &OwnerData, OleVariant &AS_GetParams_result);
	HRESULT __safecall AS_RowRequest(const WideString ProviderName, const OleVariant Row, int RequestType, OleVariant &OwnerData, OleVariant &AS_RowRequest_result);
	HRESULT __safecall AS_Execute(const WideString ProviderName, const WideString CommandText, OleVariant &Params, OleVariant &OwnerData);
	HRESULT __stdcall InterfaceSupportsErrorInfo(const GUID &iid);
	
public:
	__fastcall TLocalAppServer(TCustomProvider* AProvider)/* overload */;
	__fastcall TLocalAppServer(Db::TDataSet* ADataset)/* overload */;
	__fastcall virtual ~TLocalAppServer(void);
	virtual HRESULT __fastcall SafeCallException(System::TObject* ExceptObject, void * ExceptAddr);
private:
	void *__IAppServer;	/* Midas::IAppServer */
	void *__ISupportErrorInfo;	/* ISupportErrorInfo */
	
public:
	operator ISupportErrorInfo*(void) { return (ISupportErrorInfo*)&__ISupportErrorInfo; }
	operator IAppServer*(void) { return (IAppServer*)&__IAppServer; }
	
};


__interface IProviderContainer;
typedef System::DelphiInterface<IProviderContainer> _di_IProviderContainer;
__interface  INTERFACE_UUID("{EEE9FFD4-752F-11D4-80DD-00C04F6BB88C}") IProviderContainer  : public IInterface 
{
	
public:
	virtual void __fastcall RegisterProvider(TCustomProvider* Prov) = 0 ;
	virtual void __fastcall UnRegisterProvider(TCustomProvider* Prov) = 0 ;
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE bool InformixLob;
extern PACKAGE int ResetOption;
extern PACKAGE int MetaDataOption;
extern PACKAGE int XMLOption;
extern PACKAGE int XMLUTF8Option;
extern PACKAGE System::TObject* __fastcall GetObjectProperty(Classes::TPersistent* Instance, const AnsiString PropName);
extern PACKAGE WideString __fastcall GetStringProperty(Classes::TPersistent* Instance, const AnsiString PropName);
extern PACKAGE Variant __fastcall VarArrayFromStrings(Classes::TStrings* Strings);
extern PACKAGE Variant __fastcall VarArrayFromWideStrings(Widestrings::TWideStrings* Strings);

}	/* namespace Provider */
using namespace Provider;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Provider
